﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using r12.Models;

namespace r12.Controllers
{
    public class BookingController : Controller
    {
        public ViewResult MakeBooking()
        {
            var initialState = new Appointment
            {
                AppointmentDate = DateTime.Now.Date
            };
            return View(initialState);
        }

        [HttpPost]
        public ActionResult MakeBooking(Appointment appt, bool acceptsTerms)
        {
            if (string.IsNullOrEmpty(appt.ClientName))
                ModelState.AddModelError("ClientName", "Proszę podać nazwisko");

            if (ModelState.IsValidField("AppointmentDate"))
            {
                // Przetworzona wartość DateTime. Jednak czy jest akceptowalna w aplikacji? 
                if (appt.AppointmentDate < DateTime.Now.Date)
                    ModelState.AddModelError("AppointmentDate", "Data w przeszłości");
                else if ((appt.AppointmentDate - DateTime.Now).TotalDays > 7)
                    ModelState.AddModelError("AppointmentDate",
                                     "Nie można rezerwować na więcej niż tydzień do przodu");
            }

            if (!acceptsTerms)
                ModelState.AddModelError("acceptsTerms", "Musisz zaakceptować zasady");

            bool isSaturday = appt.AppointmentDate.DayOfWeek == DayOfWeek.Saturday;
            if (appt.ClientName == "Stefan" && isSaturday)
                ModelState.AddModelError("" /* klucz */, "Stefan nie może rejestrować w soboty"); 

            if (ModelState.IsValid)
            {
                // Faktycznie zapisz spotkanie do bazy danych lub wykonaj inne operacje
                return View("Completed", appt);
            }
            else
                return View(); // Powtórne generowanie tego samego widoku, aby użytkownik mógł poprawić błędy
        } 


    } 

}
